// Compute.cpp: dfinit le point d'entre pour l'application console.
//

#include "stdafx.h"
#include "GSolve.h"
#include "GVector.h"
#include "GMatrix.h"


#undef _LOG
#define _LOG

struct Point3D
{
public:
	double _x, _y, _z;
	void setXYZ(double x, double y, double z){_x = x; _y = y; _z = z;}
};

struct Vector3D
{
public:
	double _x, _y, _z;

	Vector3D(){};
	Vector3D(double x, double y, double z){_x = x; _y = y; _z = z;}
	
	void setXYZ(double x, double y, double z){_x = x; _y = y; _z = z;}
	void normalize() {
		double t = sqrt( _x*_x + _y*_y + _z*_z );
		if (t > DBL_EPSILON)
		{
			_x /= t;
			_y /= t;
			_z /= t;
		}
	}
	friend Vector3D operator ^ (const Vector3D& a,const Vector3D& b) 
	{
		return Vector3D(a._y*b._z-a._z*b._y,
		              a._z*b._x-a._x*b._z,
		              a._x*b._y-a._y*b._x);
	
	}
	friend bool operator==(const Vector3D& a,const Vector3D& b){return a._x==b._x && a._y==b._y && a._z==b._z; }
};

void importXYZ(string path, std::vector<Point3D> &vPts)
{
	std::vector<Point3D> vlist;

	//  Ouverture du fichier 
	int nb=0;
	ifstream file;
	file.open(path);
	std::string line;

	// Traitement sur le fichier
	if(file)
	{
		//  Lecture du fichier en utilisant ifstream 
		//vector<double> vect;
		char *word, *p_stop;
		double x=0., y=0., z=0.;
		double db;
		int aNumb;


		while(getline(file,line))
		{
			aNumb=0;

			aNumb = sscanf_s(line.c_str(), "%lf %lf %lf", &x, &y, &z);
			Point3D pt;	
			pt._x=x, pt._y=y, pt._z=z;
			vlist.push_back(pt);

			//vect.clear();
			//word = strtok ((char *)line.c_str()," \t;");
			//while (word != NULL)
			//{
			//	db = strtod(word,&p_stop);
			//	if(*p_stop == '\0')
			//		vect.push_back(db);
			//	word = strtok (NULL, " \t;");
			//}

			//if(vect.size() == 3/*aNumb==3*/)
			//{
			//	Point3D pt;	
			//	pt._x=vect[0], pt._y=vect[1], pt._z=vect[2];
			//	vlist.push_back(pt);
			//}
		}
	}
	vPts = vlist;
}

#define MAX_ITERATIONS_TORUS 60
#define BIG_VALUE 10.e12
#define VECT_NULL Vector3D(0,0,0)

Point3D _point;
Vector3D _vector;
Vector3D _best_vector;
double _score, _best_score, _radius, _radius2;

GMatrix constructRAZ(const Vector3D & zVector)
{
	Vector3D ZZ = zVector;
	ZZ.normalize();				

	Vector3D XX(1.,0.,0.);               
	if ((XX^ZZ)==VECT_NULL) XX.setXYZ(0.,1.,0.);  

	Vector3D YY = ZZ ^ XX;   
	YY.normalize();				

	XX = YY ^ ZZ;
	XX.normalize();

	GMatrix result(4,4);	

	result(1,1)=XX._x;	result(1,2)=YY._x;	result(1,3)=ZZ._x;	result(1,4)=0.0;
	result(2,1)=XX._y;	result(2,2)=YY._y;	result(2,3)=ZZ._y;	result(2,4)=0.0;
	result(3,1)=XX._z;	result(3,2)=YY._z;	result(3,3)=ZZ._z;	result(3,4)=0.0;
	result(4,1)=0.0;	result(4,2)=0.0;	result(4,3)=0.0;	result(4,4)=1.0;

	return result;
}
GMatrix getIHM(const GMatrix & T12)
{
	GMatrix  inv_T12(4,4);

	inv_T12(1,1)=T12(1,1)	;inv_T12(1,2)=T12(2,1)	;inv_T12(1,3)=T12(3,1)	;
	inv_T12(2,1)=T12(1,2)	;inv_T12(2,2)=T12(2,2)	;inv_T12(2,3)=T12(3,2)	;
	inv_T12(3,1)=T12(1,3)	;inv_T12(3,2)=T12(2,3)	;inv_T12(3,3)=T12(3,3)	;

	inv_T12(1,4)=-(inv_T12(1,1)*T12(1,4)+inv_T12(1,2)*T12(2,4)+inv_T12(1,3)*T12(3,4));
	inv_T12(2,4)=-(inv_T12(2,1)*T12(1,4)+inv_T12(2,2)*T12(2,4)+inv_T12(2,3)*T12(3,4));
	inv_T12(3,4)=-(inv_T12(3,1)*T12(1,4)+inv_T12(3,2)*T12(2,4)+inv_T12(3,3)*T12(3,4));

	inv_T12(4,1)=0			;inv_T12(4,2)=0			;inv_T12(4,3)=0			;inv_T12(4,4)=1;
	return inv_T12;
}

GMatrix getHM(double Tu, double Tv, double Tw, double Ru, double Rv, double Rw){

	GMatrix  T12(4,4);

	double cGamma = cos(Ru),		sGamma = sin(Ru),
		   cBeta  = cos(Rv),		sBeta  = sin(Rv),  
		   cAlpha = cos(Rw),		sAlpha = sin(Rw); 	

	T12(1,1) = cAlpha*cBeta;	T12(1,2) = cAlpha*sBeta*sGamma-sAlpha*cGamma;	T12(1,3) = cAlpha*sBeta*cGamma+sAlpha*sGamma;
	T12(2,1) = sAlpha*cBeta;	T12(2,2) = sAlpha*sBeta*sGamma+cAlpha*cGamma;	T12(2,3) = sAlpha*sBeta*cGamma-cAlpha*sGamma;
	T12(3,1) = -sBeta;			T12(3,2) = cBeta*sGamma;						T12(3,3) = cBeta*cGamma;

	T12(1,4)= Tu;
	T12(2,4)= Tv;
	T12(3,4)= Tw;

	T12(4,1)=0;		T12(4,2)=0;		T12(4,3)=0;		T12(4,4)=1;

	return T12;
}

void fprintT(FILE * f, GMatrix &TR){
			fprintf(f,"\n%2.12f\t%2.12f\t%2.12f\t%2.12f\n",	TR.getElement(1,1),
															TR.getElement(1,2),
															TR.getElement(1,3),
															TR.getElement(1,4));
														
			fprintf(f,"%2.12f\t%2.12f\t%2.12f\t%2.12f\n",	TR.getElement(2,1),
															TR.getElement(2,2),
															TR.getElement(2,3),
															TR.getElement(2,4));
														
			fprintf(f,"%2.12f\t%2.12f\t%2.12f\t%2.12f\n",	TR.getElement(3,1),
															TR.getElement(3,2),
															TR.getElement(3,3),
															TR.getElement(3,4));
													
			fprintf(f,"%2.12f\t%2.12f\t%2.12f\t%2.12f\n\n",	TR.getElement(4,1),
															TR.getElement(4,2),
															TR.getElement(4,3),
															TR.getElement(4,4));
}

int compute(std::vector <Point3D> &v, bool rot, const int &step, const Vector3D &iniA){

#ifdef _LOG
	FILE * fllog;
	//fllog=fopen_s("logCompute.log","w");
	fopen_s(&fllog,"logCompute.log","w");
	fprintf(fllog,"--------------- CALCUL ------------\n");
#endif

	ofstream myfile;
	myfile.open ("details.txt");


	GMatrix TRSFcurrent(4,4);
	GMatrix TRSFcurrentInv(4,4);
	GMatrix TRSFtotal(4,4);
	GMatrix TRSFfinal(4,4);

	
	double sx=0., sy=0., sz=0., sxsi=0.;
	double x, y, z;
	double xmin= DBL_MAX, ymin= DBL_MAX, zmin= DBL_MAX;
	double xmax=-DBL_MAX, ymax=-DBL_MAX, zmax=-DBL_MAX;
	double w, l, h;

	for (unsigned int i=0 ; i<v.size(); i++ )
	{
		x = v.at(i)._x;
		y = v.at(i)._y;
		z = v.at(i)._z;
			
		sx += x; xmin = min(xmin,x); xmax = max(xmax,x);
		sy += y; ymin = min(ymin,y); ymax = max(ymax,y);
		sz += z; zmin = min(zmin,z); zmax = max(zmax,z);
	}
	sx /= v.size(); w = xmax - xmin;
	sy /= v.size(); l = ymax - ymin;
	sz /= v.size(); h = zmax - zmin;

	double radius2 = min(w,min(l,h)) / 2.;
	double radius = max(w,max(l,h)) / 2. - radius2;

	cout << "radius2\t" << radius2 << endl;
	cout << "radius \t" << radius  << endl;

#ifdef _LOG
	fprintf(fllog,"R est = %2.3f\n",radius);
	fprintf(fllog,"r est = %2.3f\n",radius2);
#endif

	TRSFcurrent = constructRAZ(iniA);
	TRSFcurrent(1,4)=sx;
	TRSFcurrent(2,4)=sy;
	TRSFcurrent(3,4)=sz;

	TRSFcurrentInv = getIHM(TRSFcurrent);
	TRSFtotal = TRSFcurrentInv;
	TRSFfinal = TRSFcurrent;

	//fprintTransformation(fllog,TRSFcurrent);
	//fprintTransformation(fllog,TRSFcurrentInv); 
	//fprintTransformation(fllog,TRSFfinal);
  
	int numSignatures = (rot?7:5); // 5 if true and 3 if false

	int n = v.size();
	GVector SR_ResuSig(numSignatures);
	GVector SR_VectXsi(n);
	GMatrix SR_MatSig(n,numSignatures);
	GVector SR_Residu(n);
	
	int nb_interation = 0; 

	GVector pointOld(4);
	GVector pointNew(4);

	while (nb_interation <= MAX_ITERATIONS_TORUS){

		cout << "Itration " << nb_interation << endl;

		sxsi=0.;
		
		double y,x,z, r, r2, xsi, r3d, n1, n2, er, n21, n22, r3, Nx, Ny, Nz, theta;

		int numValidPoints = 0;

		for ( int j=0 ; j<n; j+=step )
		{ 
			Point3D vi=v.at(j);

			pointOld(1) = vi._x;
			pointOld(2) = vi._y;
			pointOld(3) = vi._z;
			pointOld(4) = 1.0;

			pointNew = TRSFtotal * pointOld;

			x = pointNew(1);
			y = pointNew(2);
			z = pointNew(3);

			r = sqrt(x*x+y*y);
			n1 = x/r;
			n2 = y/r;
			er = r-radius;

			r2 = sqrt(er*er+z*z); ;
			n21 = er/r2;
			n22 = z/r2;
			xsi = r2 - radius2;
			
			Nx=n1*n21;
			Ny=n2*n21; 
			Nz=n22;


			numValidPoints++;

			SR_VectXsi( numValidPoints )  = xsi;
			sxsi += (xsi*xsi);

			myfile << nb_interation << "\t" << j << "\t" << r << "\t" << er << "\t" << r2 << "\t" << xsi << "\t" << sxsi << endl;


			SR_MatSig( numValidPoints, 1) = Nx;
			SR_MatSig( numValidPoints, 2) = Ny;
			SR_MatSig( numValidPoints, 3) = Nz; 
			
			SR_MatSig( numValidPoints, 4) = n21;
			SR_MatSig( numValidPoints, 5) = 1.;

			if (rot) SR_MatSig( numValidPoints, 6) = Nz*y-Ny*z;
			if (rot) SR_MatSig( numValidPoints, 7) = Nx*z-Nz*x;
		} 
	
		GSolve SR_Solve (SR_MatSig,SR_VectXsi,numValidPoints);

		SR_ResuSig =  SR_Solve.result();

		double Tu    = SR_ResuSig(1);
		double Tv    = SR_ResuSig(2);
		double Tw    = SR_ResuSig(3);
	
		double dR    = SR_ResuSig(4);
		double dR2   = SR_ResuSig(5);

		double Ru    = (rot?SR_ResuSig(6):0.);
		double Rv    = (rot?SR_ResuSig(7):0.);

#ifdef _LOG
		fprintf(fllog,"Tu = %2.3f\n",Tu);
		fprintf(fllog,"Tv = %2.3f\n",Tv);
		fprintf(fllog,"Tw = %2.3f\n",Tw);
		fprintf(fllog,"Ru = %2.3f\n",Ru);
		fprintf(fllog,"Rv = %2.3f\n",Rv);
		fprintf(fllog,"dR = %2.3f\n",dR);
		fprintf(fllog,"dS = %2.3f\n\n",dR2);
#endif

		if (_isnan(Tu) || _isnan(Tv) || _isnan(Tw) ||_isnan(Ru) ||_isnan(Rv) || _isnan(dR) || _isnan(dR2)
			|| Tu > BIG_VALUE || Tv > BIG_VALUE || Tw > BIG_VALUE || Ru > BIG_VALUE || Rv > BIG_VALUE 
			|| dR > BIG_VALUE || dR2 > BIG_VALUE )
		{
#ifdef _LOG
			fclose (fllog);
#endif
			return -1;
		}

		_score = numValidPoints * numValidPoints / (sxsi + 0.01);

		TRSFcurrent = getHM(Tu,Tv,Tw,Ru,Rv,0.0);
		TRSFcurrentInv = getIHM(TRSFcurrent);
	

		TRSFtotal = TRSFcurrentInv * TRSFtotal;
		TRSFfinal = TRSFfinal * TRSFcurrent;

		radius += dR;
		radius2 += dR2;

		radius = abs(radius);
		radius2 = abs(radius2);

		cout << "radius2\t" << radius2 << endl;
		cout << "radius \t" << radius  << endl;
		
		if (radius > 20. * max (w,max(l,h))  || radius2 > 20. * max (w,max(l,h))  ) {
#ifdef _LOG
			fclose (fllog);
#endif
			return -2;
		}

#ifdef _LOG
		fprintf(fllog,"Nouveau R : %g %g\n",radius, radius2);
		fprintT(fllog,TRSFtotal);
		fprintf(fllog,"FIN %d\n",nb_interation );
#endif
		nb_interation ++;
	}
     
	_point.setXYZ(TRSFfinal(1,4),
				  TRSFfinal(2,4),
				  TRSFfinal(3,4));

	_vector.setXYZ(TRSFfinal(1,3),
				   TRSFfinal(2,3),
				   TRSFfinal(3,3));
	if (_score > _best_score) {
		_best_score = _score;
		_best_vector = _vector;

		cout << "_best_score\t" << _best_score <<endl;
		cout << "_best_vector\n" << _best_vector._x << "\n"  << _best_vector._y << "\n" << _best_vector._z <<endl;
	}

	_radius = radius;
	_radius2 = radius2;
#ifdef _LOG
	fprintf(fllog,"_best_score = %2.3f\n",_best_score);
	fprintf(fllog,"_best_vector = %2.3f\t%2.3f\t%2.3f\n",_best_vector._x, _best_vector._y, _best_vector._z);

	fprintf(fllog,"Point = %2.3f\t%2.3f\t%2.3f\n",_point._x,_point._y, _point._z);
	fprintf(fllog,"Vector = %2.3f\t%2.3f\t%2.3f\n",_vector._x,_vector._y, _vector._z);

	fprintf(fllog,"_radius = %2.3f\n",_radius);
	fprintf(fllog,"_radius2 = %2.3f\n",_radius2);


	fclose (fllog);
#endif

	myfile.close();
	return 0;
}


int _tmain(int argc, _TCHAR* argv[])
{
	std::vector<Point3D> v2Pts;

	importXYZ("Tr.xyz", v2Pts);

	int retval = 0;
	bool rot = true;

	retval = compute(v2Pts,rot,10,Vector3D(1,0,0));

	cout << "\nDefined\t" << retval << endl;
	system("pause");
	return 0;
}

